<?php

namespace NixfilePlugin;

use NixfilePlugin\Admin\Ajax;
use NixfilePlugin\Admin\GalleryPage;
use NixfilePlugin\Helper\Backup;
use NixfilePlugin\Helper\Jalali;

class Plugin {
	private const OPTION_KEY = "nixfile-options";

	public static function optionKey(): string {
		return self::OPTION_KEY;
	}

	public static function getOptions(): array {
		return get_option( self::OPTION_KEY );
	}

	public function init() {
		add_action( "admin_menu", [ GalleryPage::class, "register" ] );
		add_action( 'wp_ajax_nixfile_list', [ Ajax::class, 'list' ] );
		add_action( 'wp_ajax_nixfile_upload', [ Ajax::class, 'uploadFile' ] );
		add_action( "wp_ajax_nixfile_settings", [ Ajax::class, 'updateSetting' ] );

		add_action( 'admin_enqueue_scripts', [ GalleryPage::class, 'enqueueAssets' ] );
		add_action( 'init', [ Jalali::class, 'register' ] );
		add_action( "init", [ Backup::class, 'register' ] );
	}


}